from app import create_app
import os

app = create_app()


@app.shell_context_processor
def make_shell_context():
    """Add models to shell context"""
    from app.models.user import User
    return {'User': User}


if __name__ == '__main__':
    host = os.getenv('HOST', '0.0.0.0')
    port = int(os.getenv('PORT', 5009))
    app.run(host=host, port=port, debug=True)
