from mongoengine import Document, StringField, EmailField, DateTimeField, BooleanField, DictField
from datetime import datetime
import uuid


class User(Document):
    """User model"""
    meta = {'collection': 'users'}

    user_id = StringField(required=True, unique=True, default=lambda: str(uuid.uuid4()))
    email = EmailField(required=True, unique=True)
    password = StringField(required=True)
    full_name = StringField(required=True)
    user_type = StringField(required=True, choices=['US', 'AD'])  # US=User, AD=Admin
    phone = StringField()
    is_active = BooleanField(default=True)
    is_verified = BooleanField(default=False)
    profile_data = DictField()
    created_by = StringField()  # user_id of creator
    updated_by = StringField()  # user_id of last updater
    created_at = DateTimeField(default=datetime.utcnow)
    updated_at = DateTimeField(default=datetime.utcnow)

    def __repr__(self):
        return f'<User {self.email}>'
